import { generatePageMetadata } from "@/lib/seo/metadata"
import { ResetPasswordForm } from "@/components/frontend/reset-password-form"
import { AuthLayout } from "@/components/frontend/auth-layout"
import type { Metadata } from "next"
import Link from "next/link"
import { redirect } from "next/navigation"
import { verifyResetFlowForPasswordReset } from "@/lib/auth/session"

export const metadata: Metadata = generatePageMetadata({
  title: "Reset Password",
  description: "Create a new password for your Teertham account",
  path: "/reset-password",
  noIndex: true,
})

export default async function ResetPasswordPage() {
  const { valid, email } = await verifyResetFlowForPasswordReset()

  if (!valid || !email) {
    redirect("/forget-password")
  }

  return (
    <AuthLayout variant="reset-password">
      <article className="space-y-6">
        <header className="text-center space-y-2">
          <h1 className="text-3xl font-bold text-balance">Reset Password</h1>
          <p className="text-muted-foreground text-pretty">Create a new secure password for your account</p>
        </header>

        <section className="bg-card border rounded-xl p-6 shadow-sm space-y-6">
          <ResetPasswordForm email={email} />

          <div className="text-center pt-4 border-t">
            <p className="text-sm text-muted-foreground">
              Password reset successful?{" "}
              <Link href="/login" className="text-primary hover:underline font-medium">
                Sign In
              </Link>
            </p>
          </div>
        </section>
      </article>
    </AuthLayout>
  )
}
