import type { Metadata } from "next"
import { Suspense } from "react"
import { generatePageMetadata, generateJsonLd } from "@/lib/seo/metadata"
import { LegalPageEditor } from "@/components/admin/legal/legal-page-editor"
import { Skeleton } from "@/components/ui/skeleton"

export const metadata: Metadata = generatePageMetadata({
  title: "Cancellation Policy",
  description: "Manage cancellation policy for Teertham platform bookings. Edit meta information and content.",
  path: "/admin/cancellation-policy",
  noIndex: true,
})

function EditorLoading() {
  return (
    <div className="space-y-6">
      <div className="space-y-2">
        <Skeleton className="h-8 w-48" />
        <Skeleton className="h-4 w-96" />
      </div>
      <Skeleton className="h-64 w-full rounded-xl" />
      <Skeleton className="h-96 w-full rounded-xl" />
    </div>
  )
}

export default function CancellationPolicyPage() {
  const jsonLd = generateJsonLd({
    "@type": "WebPage",
    name: "Cancellation Policy Management | Teertham Admin",
    description: "Administrative interface for managing booking cancellation policy.",
  })

  return (
    <>
      <script type="application/ld+json" dangerouslySetInnerHTML={jsonLd} />
      <main>
        <Suspense fallback={<EditorLoading />}>
          <LegalPageEditor
            slug="cancellation-policy"
            title="Cancellation Policy"
            description="Manage the cancellation policy for hotel and package bookings."
          />
        </Suspense>
      </main>
    </>
  )
}
