import type { Metadata } from "next"
import { WithdrawalsClient } from "@/components/admin/withdrawals/withdrawals-client"

export const metadata: Metadata = {
  title: "Hotel Withdraw | Teertham Admin",
  description: "Manage and process hotel withdrawal requests. View pending, approved, and cancelled withdrawals.",
  openGraph: {
    title: "Hotel Withdraw | Teertham Admin",
    description: "Manage and process hotel withdrawal requests.",
    type: "website",
  },
}

export default function HotelWithdrawPage() {
  return (
    <WithdrawalsClient
      userType="hotel"
      title="Hotel Withdraw"
      description="View and manage all hotel withdrawal requests"
    />
  )
}
