import type React from "react"
import type { Metadata } from "next"
import { AdminSidebarServer } from "@/components/admin/admin-sidebar-server"
import { AdminHeaderServer } from "@/components/admin/admin-header-server"
import { AdminMobileNav } from "@/components/admin/admin-mobile-nav"

export const metadata: Metadata = {
  title: "Admin | Teertham",
  description: "Teertham Platform Administration",
  robots: {
    index: false,
    follow: false,
  },
}

// Authentication is already handled by middleware, so no need to re-validate here
// This prevents the layout from re-executing on every navigation
export default function AdminLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <div className="flex min-h-screen bg-background">
      {/* Server-rendered sidebar - static, never re-renders on navigation */}
      <AdminSidebarServer />

      {/* Mobile navigation - client component only for mobile toggle */}
      <AdminMobileNav />

      {/* Main content area */}
      <div className="flex flex-1 flex-col md:ml-64">
        {/* Server-rendered header - static, never re-renders on navigation */}
        <AdminHeaderServer />

        <main className="flex-1 bg-background overflow-hidden">
          <div className="container mx-auto p-4 md:p-6 lg:p-8 max-w-full overflow-x-auto">{children}</div>
        </main>
      </div>
    </div>
  )
}
