import { generatePageMetadata, generateJsonLd } from "@/lib/seo/metadata"
import { AdminProfileClient } from "@/components/admin/profile/admin-profile-client"
import type { Metadata } from "next"

export const metadata: Metadata = generatePageMetadata({
  title: "Manage Profile",
  description:
    "Manage your admin profile, update personal information, change email and password securely on Teertham.",
  path: "/admin/profile",
  noIndex: true,
})

export default function AdminProfilePage() {
  const jsonLd = generateJsonLd({
    "@type": "ProfilePage",
    name: "Admin Profile | Teertham",
    description: "Manage admin profile and account settings",
  })

  return (
    <>
      <script type="application/ld+json" dangerouslySetInnerHTML={jsonLd} />
      <main>
        <AdminProfileClient />
      </main>
    </>
  )
}
