import type { Metadata } from "next"
import { Suspense } from "react"
import { RoutesClient } from "@/components/admin/routes/routes-client"
import { Skeleton } from "@/components/ui/skeleton"

export const metadata: Metadata = {
  title: "Routes Listing | Teertham Admin",
  description: "Manage vehicle routes with origin, destination cities, and vehicle pricing for the Teertham platform.",
  robots: { index: false, follow: false },
  openGraph: {
    title: "Routes Listing | Teertham Admin",
    description: "Manage vehicle routes with origin, destination, and pricing configuration.",
    type: "website",
  },
  twitter: {
    card: "summary",
    title: "Routes Listing | Teertham Admin",
    description: "Manage vehicle routes and pricing.",
  },
}

function RoutesLoadingSkeleton() {
  return (
    <div className="space-y-6">
      <div className="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
        <div className="space-y-2">
          <Skeleton className="h-8 w-48" />
          <Skeleton className="h-4 w-72" />
        </div>
        <Skeleton className="h-10 w-36" />
      </div>
      <Skeleton className="h-12 w-80" />
      <Skeleton className="h-96 w-full" />
    </div>
  )
}

export default function RoutesListingPage() {
  return (
    <main className="flex-1 p-4 sm:p-6 lg:p-8">
      <Suspense fallback={<RoutesLoadingSkeleton />}>
        <RoutesClient />
      </Suspense>

      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify({
            "@context": "https://schema.org",
            "@type": "WebPage",
            name: "Routes Listing",
            description: "Manage vehicle routes with origin, destination, and pricing.",
            isPartOf: {
              "@type": "WebSite",
              name: "Teertham Admin",
            },
          }),
        }}
      />
    </main>
  )
}
