import { generatePageMetadata, generateJsonLd } from "@/lib/seo/metadata"
import { AdminSettingsClient } from "@/components/admin/settings/admin-settings-client"
import type { Metadata } from "next"

export const metadata: Metadata = generatePageMetadata({
  title: "Admin Settings",
  description:
    "Configure platform settings including SMTP, payment gateway, agent commissions, and withdrawal options for the Teertham admin panel.",
  path: "/admin/settings",
  noIndex: true,
})

export default function AdminSettingsPage() {
  const jsonLd = generateJsonLd({
    "@type": "WebPage",
    name: "Admin Settings | Teertham",
    description: "Platform configuration and settings management",
  })

  return (
    <>
      <script type="application/ld+json" dangerouslySetInnerHTML={jsonLd} />
      <main>
        <AdminSettingsClient />
      </main>
    </>
  )
}
