import type { Metadata } from "next"
import { Suspense } from "react"
import { generatePageMetadata, generateJsonLd } from "@/lib/seo/metadata"
import { LegalPageEditor } from "@/components/admin/legal/legal-page-editor"
import { Skeleton } from "@/components/ui/skeleton"

export const metadata: Metadata = generatePageMetadata({
  title: "FAQ",
  description: "Manage frequently asked questions for Teertham platform. Edit meta information and content.",
  path: "/admin/user-faq",
  noIndex: true,
})

function EditorLoading() {
  return (
    <div className="space-y-6">
      <div className="space-y-2">
        <Skeleton className="h-8 w-48" />
        <Skeleton className="h-4 w-96" />
      </div>
      <Skeleton className="h-64 w-full rounded-xl" />
      <Skeleton className="h-96 w-full rounded-xl" />
    </div>
  )
}

export default function UserFaqPage() {
  const jsonLd = generateJsonLd({
    "@type": "FAQPage",
    name: "FAQ Management | Teertham Admin",
    description: "Administrative interface for managing frequently asked questions.",
  })

  return (
    <>
      <script type="application/ld+json" dangerouslySetInnerHTML={jsonLd} />
      <main>
        <Suspense fallback={<EditorLoading />}>
          <LegalPageEditor
            slug="user-faq"
            title="Frequently Asked Questions"
            description="Manage the FAQ section that helps users find answers to common questions."
          />
        </Suspense>
      </main>
    </>
  )
}
