import type { Metadata } from "next"
import { Suspense } from "react"
import { VehiclesClient } from "@/components/admin/vehicles/vehicles-client"
import { Skeleton } from "@/components/ui/skeleton"

export const metadata: Metadata = {
  title: "Vehicle Listing | Teertham Admin",
  description:
    "Manage all vehicles available for booking on the Teertham platform. Add, edit, and manage vehicle listings with pricing.",
  openGraph: {
    title: "Vehicle Listing | Teertham Admin",
    description: "Manage all vehicles available for booking on the Teertham platform.",
    type: "website",
  },
  twitter: {
    card: "summary",
    title: "Vehicle Listing | Teertham Admin",
    description: "Manage all vehicles available for booking on the Teertham platform.",
  },
  robots: {
    index: false,
    follow: false,
  },
}

function VehicleListingSkeleton() {
  return (
    <div className="space-y-6">
      <div className="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
        <div className="space-y-2">
          <Skeleton className="h-8 w-48" />
          <Skeleton className="h-4 w-64" />
        </div>
        <Skeleton className="h-10 w-32" />
      </div>
      <Skeleton className="h-10 w-80" />
      <Skeleton className="h-96 w-full" />
    </div>
  )
}

export default function VehicleListingPage() {
  return (
    <main className="space-y-6">
      <Suspense fallback={<VehicleListingSkeleton />}>
        <VehiclesClient />
      </Suspense>

      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify({
            "@context": "https://schema.org",
            "@type": "WebPage",
            name: "Vehicle Listing | Teertham Admin",
            description: "Manage all vehicles available for booking on the Teertham platform.",
            publisher: {
              "@type": "Organization",
              name: "Teertham",
            },
          }),
        }}
      />
    </main>
  )
}
