import type { Metadata } from "next"
import { Suspense } from "react"
import { generatePageMetadata, generateJsonLd } from "@/lib/seo/metadata"
import { LegalPageEditor } from "@/components/admin/legal/legal-page-editor"
import { Skeleton } from "@/components/ui/skeleton"

export const metadata: Metadata = generatePageMetadata({
  title: "Withdraw Terms",
  description: "Manage withdrawal terms for partners on Teertham platform. Edit meta information and content.",
  path: "/admin/withdraw-terms",
  noIndex: true,
})

function EditorLoading() {
  return (
    <div className="space-y-6">
      <div className="space-y-2">
        <Skeleton className="h-8 w-48" />
        <Skeleton className="h-4 w-96" />
      </div>
      <Skeleton className="h-64 w-full rounded-xl" />
      <Skeleton className="h-96 w-full rounded-xl" />
    </div>
  )
}

export default function WithdrawTermsPage() {
  const jsonLd = generateJsonLd({
    "@type": "WebPage",
    name: "Withdraw Terms Management | Teertham Admin",
    description: "Administrative interface for managing partner withdrawal terms.",
  })

  return (
    <>
      <script type="application/ld+json" dangerouslySetInnerHTML={jsonLd} />
      <main>
        <Suspense fallback={<EditorLoading />}>
          <LegalPageEditor
            slug="withdraw-terms"
            title="Withdrawal Terms"
            description="Manage the terms for agents and hotels withdrawing their earnings."
          />
        </Suspense>
      </main>
    </>
  )
}
