import type React from "react"
import type { Metadata, Viewport } from "next"

export const metadata: Metadata = {
  title: {
    template: "%s | Hotel Dashboard - Teertham",
    default: "Hotel Dashboard | Teertham",
  },
  description: "Manage your hotel bookings, rooms, and earnings on Teertham Hotel Partner Dashboard",
  robots: {
    index: false,
    follow: false,
  },
  openGraph: {
    title: "Hotel Dashboard | Teertham",
    description: "Teertham Hotel Partner Dashboard",
    type: "website",
  },
}

export const viewport: Viewport = {
  width: "device-width",
  initialScale: 1,
  maximumScale: 1,
  userScalable: false,
  themeColor: [
    { media: "(prefers-color-scheme: light)", color: "#ffffff" },
    { media: "(prefers-color-scheme: dark)", color: "#0f172a" },
  ],
}

export default function HotelLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return <>{children}</>
}
