import type { Metadata } from "next"
import { ManageProfileClientPage } from "@/app/hotel/manage-profile/client-page"

export const metadata: Metadata = {
  title: "Manage Profile",
  description: "Update your profile information, security settings, and notification preferences",
}

export default async function ManageProfilePage({ searchParams }: { searchParams: Promise<{ tab?: string }> }) {
  const params = await searchParams
  return <ManageProfileClientPage initialTab={params.tab || "profile"} />
}
