import type { Metadata } from "next"
import { Suspense } from "react"
import { HotelPageWrapper } from "@/components/hotel/hotel-page-wrapper"
import { HotelSidebarNav } from "@/components/hotel/hotel-sidebar-nav"
import { HotelSettingsForm } from "@/components/hotel/settings/hotel-settings-form"
import { RoomSettingsForm } from "@/components/hotel/settings/room-settings-form"
import { SettingsLoadingSkeleton } from "@/components/hotel/settings/settings-loading-skeleton"

export const metadata: Metadata = {
  title: "Hotel & Room Settings",
  description: "Configure your hotel details, facilities, and manage room inventory",
}

interface RoomSettingsPageProps {
  searchParams: Promise<{ tab?: string }>
}

export default async function HotelRoomSettingsPage({ searchParams }: RoomSettingsPageProps) {
  const params = await searchParams
  const tab = params.tab || "hotel"

  return (
    <HotelPageWrapper>
      <div className="space-y-6">
        {/* Page Header */}
        <header>
          <h1 className="text-3xl font-bold tracking-tight text-foreground">Hotel & Room Settings</h1>
          <p className="text-muted-foreground mt-1">Configure your hotel details and manage room inventory</p>
        </header>

        {/* Main Content Layout */}
        <div className="flex flex-col lg:flex-row gap-6">
          <HotelSidebarNav type="settings" />
          <main className="flex-1" role="main" aria-label="Settings content">
            <Suspense fallback={<SettingsLoadingSkeleton />}>
              {tab === "hotel" ? <HotelSettingsForm /> : <RoomSettingsForm />}
            </Suspense>
          </main>
        </div>
      </div>
    </HotelPageWrapper>
  )
}
