"use client"

import Link from "next/link"
import {
  Car,
  Hotel,
  Sparkles,
  Package,
  Phone,
  Mail,
  MapPin,
  Facebook,
  Twitter,
  Instagram,
  Linkedin,
} from "lucide-react"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"

export function FrontendFooter() {
  const currentYear = new Date().getFullYear()

  return (
    <footer className="frontend-gradient-footer border-t border-white/10">
      <div className="mx-auto max-w-7xl px-4 md:px-6 lg:px-8">
        {/* Main Footer Content */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 py-12 md:py-16">
          {/* Company Info */}
          <div className="space-y-4">
            <Link href="/" className="inline-flex items-center space-x-3 group">
              <div className="flex h-10 w-10 items-center justify-center rounded-xl bg-white/10 backdrop-blur-sm shadow-lg border border-white/20">
                <Sparkles className="h-5 w-5 text-white" aria-hidden="true" />
              </div>
              <span className="text-xl font-bold text-white">Teertham</span>
            </Link>
            <p className="text-sm text-white/70 leading-relaxed">
              Your trusted partner for vehicle bookings, hotel reservations, spiritual journeys, and custom travel
              packages across India.
            </p>
            <div className="flex gap-2">
              <Button
                variant="outline"
                size="icon"
                className="h-9 w-9 bg-white/5 border-white/20 text-white hover:bg-white/10 hover:text-white"
                aria-label="Facebook"
              >
                <Facebook className="h-4 w-4" aria-hidden="true" />
              </Button>
              <Button
                variant="outline"
                size="icon"
                className="h-9 w-9 bg-white/5 border-white/20 text-white hover:bg-white/10 hover:text-white"
                aria-label="Twitter"
              >
                <Twitter className="h-4 w-4" aria-hidden="true" />
              </Button>
              <Button
                variant="outline"
                size="icon"
                className="h-9 w-9 bg-white/5 border-white/20 text-white hover:bg-white/10 hover:text-white"
                aria-label="Instagram"
              >
                <Instagram className="h-4 w-4" aria-hidden="true" />
              </Button>
              <Button
                variant="outline"
                size="icon"
                className="h-9 w-9 bg-white/5 border-white/20 text-white hover:bg-white/10 hover:text-white"
                aria-label="LinkedIn"
              >
                <Linkedin className="h-4 w-4" aria-hidden="true" />
              </Button>
            </div>
          </div>

          {/* Services */}
          <div className="space-y-4">
            <h3 className="text-lg font-semibold text-white">Services</h3>
            <nav className="flex flex-col space-y-3" aria-label="Services navigation">
              <Link
                href="/vehicle-booking"
                className="group flex items-center gap-2 text-sm text-white/70 hover:text-white transition-colors"
              >
                <Car className="h-4 w-4 group-hover:text-white" aria-hidden="true" />
                <span>Vehicle Booking</span>
              </Link>
              <Link
                href="/hotel-booking"
                className="group flex items-center gap-2 text-sm text-white/70 hover:text-white transition-colors"
              >
                <Hotel className="h-4 w-4 group-hover:text-white" aria-hidden="true" />
                <span>Hotel Booking</span>
              </Link>
              <Link
                href="/spiritual-packages"
                className="group flex items-center gap-2 text-sm text-white/70 hover:text-white transition-colors"
              >
                <Sparkles className="h-4 w-4 group-hover:text-white" aria-hidden="true" />
                <span>Spiritual Packages</span>
              </Link>
              <Link
                href="/custom-packages"
                className="group flex items-center gap-2 text-sm text-white/70 hover:text-white transition-colors"
              >
                <Package className="h-4 w-4 group-hover:text-white" aria-hidden="true" />
                <span>Custom Packages</span>
              </Link>
            </nav>
          </div>

          {/* Quick Links */}
          <div className="space-y-4">
            <h3 className="text-lg font-semibold text-white">Quick Links</h3>
            <nav className="flex flex-col space-y-3" aria-label="Quick links navigation">
              <Link href="/about" className="text-sm text-white/70 hover:text-white transition-colors">
                About Us
              </Link>
              <Link href="/contact" className="text-sm text-white/70 hover:text-white transition-colors">
                Contact Us
              </Link>
              <Link href="/faq" className="text-sm text-white/70 hover:text-white transition-colors">
                FAQ
              </Link>
              <Link href="/privacy-policy" className="text-sm text-white/70 hover:text-white transition-colors">
                Privacy Policy
              </Link>
              <Link href="/terms-conditions" className="text-sm text-white/70 hover:text-white transition-colors">
                Terms & Conditions
              </Link>
              <Link href="/refund-policy" className="text-sm text-white/70 hover:text-white transition-colors">
                Refund Policy
              </Link>
            </nav>
          </div>

          {/* Contact & Newsletter */}
          <div className="space-y-4">
            <h3 className="text-lg font-semibold text-white">Get In Touch</h3>
            <address className="not-italic space-y-3 text-sm text-white/70">
              <div className="flex items-start gap-2">
                <MapPin className="h-4 w-4 mt-0.5 shrink-0" aria-hidden="true" />
                <span>123 Teertham Street, Mumbai, Maharashtra 400001, India</span>
              </div>
              <div className="flex items-center gap-2">
                <Phone className="h-4 w-4 shrink-0" aria-hidden="true" />
                <a href="tel:+911234567890" className="hover:text-white transition-colors">
                  +91 123 456 7890
                </a>
              </div>
              <div className="flex items-center gap-2">
                <Mail className="h-4 w-4 shrink-0" aria-hidden="true" />
                <a href="mailto:info@teertham.com" className="hover:text-white transition-colors">
                  info@teertham.com
                </a>
              </div>
            </address>

            <div className="pt-2">
              <h4 className="text-sm font-semibold mb-2 text-white">Subscribe to Newsletter</h4>
              <form className="flex gap-2" onSubmit={(e) => e.preventDefault()}>
                <Input
                  type="email"
                  placeholder="Your email"
                  className="h-10 bg-white/10 border-white/20 text-white placeholder:text-white/50 focus:border-white/40"
                  aria-label="Email for newsletter"
                  required
                />
                <Button type="submit" size="sm" className="frontend-gradient-primary shrink-0 shadow-lg">
                  Subscribe
                </Button>
              </form>
            </div>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="border-t border-white/10 py-6">
          <div className="flex flex-col md:flex-row justify-between items-center gap-4 text-sm text-white/60">
            <p>&copy; {currentYear} Teertham. All rights reserved.</p>
            <div className="flex gap-6">
              <Link href="/privacy-policy" className="hover:text-white transition-colors">
                Privacy
              </Link>
              <Link href="/terms-conditions" className="hover:text-white transition-colors">
                Terms
              </Link>
              <Link href="/sitemap" className="hover:text-white transition-colors">
                Sitemap
              </Link>
            </div>
          </div>
        </div>
      </div>
    </footer>
  )
}
