"use client"

import { Card } from "@/components/ui/card"
import { TrendingUp, TrendingDown, CalendarCheck, IndianRupee, BedDouble, Users, Star, Percent } from "lucide-react"

const stats = [
  {
    title: "Total Bookings",
    value: "1,234",
    change: "+12.5%",
    trend: "up",
    period: "vs last month",
    icon: CalendarCheck,
    iconBg: "bg-blue-500",
  },
  {
    title: "Total Revenue",
    value: "₹8,45,000",
    change: "+8.2%",
    trend: "up",
    period: "vs last month",
    icon: IndianRupee,
    iconBg: "bg-emerald-500",
  },
  {
    title: "Available Rooms",
    value: "24",
    change: "of 30 total",
    trend: "neutral",
    period: "6 occupied",
    icon: BedDouble,
    iconBg: "bg-violet-500",
  },
  {
    title: "Total Guests",
    value: "2,456",
    change: "+15.3%",
    trend: "up",
    period: "this month",
    icon: Users,
    iconBg: "bg-cyan-500",
  },
  {
    title: "Average Rating",
    value: "4.8",
    change: "+0.2",
    trend: "up",
    period: "from 156 reviews",
    icon: Star,
    iconBg: "bg-amber-500",
  },
  {
    title: "Occupancy Rate",
    value: "85%",
    change: "-2.4%",
    trend: "down",
    period: "vs last week",
    icon: Percent,
    iconBg: "bg-rose-500",
  },
]

export function DashboardStats() {
  return (
    <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 lg:gap-5">
      {stats.map((stat) => {
        const Icon = stat.icon

        return (
          <Card
            key={stat.title}
            className="group relative overflow-hidden border bg-card hover:shadow-lg transition-all duration-300"
          >
            <div className="p-5">
              <div className="flex items-start justify-between">
                <div className="space-y-2">
                  <p className="text-sm font-medium text-muted-foreground">{stat.title}</p>
                  <p className="text-3xl font-bold tracking-tight">{stat.value}</p>
                  <div className="flex items-center gap-1.5">
                    {stat.trend === "up" && <TrendingUp className="h-4 w-4 text-emerald-500" />}
                    {stat.trend === "down" && <TrendingDown className="h-4 w-4 text-rose-500" />}
                    <span
                      className={`text-sm font-medium ${
                        stat.trend === "up"
                          ? "text-emerald-600"
                          : stat.trend === "down"
                            ? "text-rose-600"
                            : "text-muted-foreground"
                      }`}
                    >
                      {stat.change}
                    </span>
                    <span className="text-xs text-muted-foreground">{stat.period}</span>
                  </div>
                </div>

                <div className={`p-3 rounded-xl ${stat.iconBg} shadow-lg`}>
                  <Icon className="h-5 w-5 text-white" />
                </div>
              </div>
            </div>
          </Card>
        )
      })}
    </div>
  )
}
