"use client"

import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Button } from "@/components/ui/button"
import { Avatar, AvatarFallback } from "@/components/ui/avatar"
import { CalendarDays, Clock, ArrowRight } from "lucide-react"
import Link from "next/link"

const recentBookings = [
  {
    id: "BK001",
    guestName: "Rajesh Kumar",
    roomType: "Deluxe Suite",
    checkIn: "Dec 10, 2025",
    checkOut: "Dec 12, 2025",
    status: "confirmed",
    amount: "₹8,500",
  },
  {
    id: "BK002",
    guestName: "Priya Sharma",
    roomType: "Standard Room",
    checkIn: "Dec 11, 2025",
    checkOut: "Dec 13, 2025",
    status: "checked-in",
    amount: "₹4,200",
  },
  {
    id: "BK003",
    guestName: "Amit Patel",
    roomType: "Premium Suite",
    checkIn: "Dec 09, 2025",
    checkOut: "Dec 11, 2025",
    status: "checked-out",
    amount: "₹12,000",
  },
  {
    id: "BK004",
    guestName: "Sneha Reddy",
    roomType: "Deluxe Room",
    checkIn: "Dec 12, 2025",
    checkOut: "Dec 15, 2025",
    status: "pending",
    amount: "₹6,800",
  },
]

const statusStyles = {
  confirmed:
    "bg-emerald-50 text-emerald-600 border-emerald-200 dark:bg-emerald-950 dark:text-emerald-400 dark:border-emerald-800",
  "checked-in": "bg-blue-50 text-blue-600 border-blue-200 dark:bg-blue-950 dark:text-blue-400 dark:border-blue-800",
  "checked-out":
    "bg-slate-50 text-slate-600 border-slate-200 dark:bg-slate-900 dark:text-slate-400 dark:border-slate-700",
  pending: "bg-amber-50 text-amber-600 border-amber-200 dark:bg-amber-950 dark:text-amber-400 dark:border-amber-800",
  cancelled: "bg-red-50 text-red-600 border-red-200 dark:bg-red-950 dark:text-red-400 dark:border-red-800",
}

export function RecentBookings() {
  return (
    <Card className="border bg-card">
      <CardHeader className="flex flex-row items-center justify-between">
        <CardTitle className="text-lg font-semibold">Recent Bookings</CardTitle>
        <Button variant="ghost" size="sm" asChild className="text-muted-foreground hover:text-foreground">
          <Link href="/hotel/bookings">
            View All <ArrowRight className="ml-1 h-4 w-4" />
          </Link>
        </Button>
      </CardHeader>

      <CardContent className="space-y-3">
        {recentBookings.map((booking) => (
          <div
            key={booking.id}
            className="group flex items-center gap-4 p-4 rounded-xl bg-muted/30 hover:bg-muted/50 border border-border/50 transition-all duration-200"
          >
            <Avatar className="h-11 w-11 border">
              <AvatarFallback className="bg-slate-100 dark:bg-slate-800 text-slate-600 dark:text-slate-300 font-semibold">
                {booking.guestName
                  .split(" ")
                  .map((n) => n[0])
                  .join("")}
              </AvatarFallback>
            </Avatar>

            <div className="flex-1 min-w-0">
              <div className="flex items-center gap-2 mb-1">
                <p className="font-semibold truncate">{booking.guestName}</p>
                <Badge variant="outline" className={statusStyles[booking.status as keyof typeof statusStyles]}>
                  {booking.status}
                </Badge>
              </div>
              <p className="text-sm text-muted-foreground">{booking.roomType}</p>
              <div className="flex items-center gap-4 mt-1.5 text-xs text-muted-foreground">
                <span className="flex items-center gap-1">
                  <CalendarDays className="h-3.5 w-3.5" />
                  {booking.checkIn}
                </span>
                <span className="flex items-center gap-1">
                  <Clock className="h-3.5 w-3.5" />
                  {booking.checkOut}
                </span>
              </div>
            </div>

            <div className="text-right">
              <p className="font-bold text-lg">{booking.amount}</p>
              <p className="text-xs text-muted-foreground">#{booking.id}</p>
            </div>
          </div>
        ))}
      </CardContent>
    </Card>
  )
}
