"use client"

import { useEffect, useState, type ReactNode } from "react"
import { useRouter } from "next/navigation"
import { HotelHeader } from "@/components/hotel/hotel-header"
import { getClientSession, validateSessionData } from "@/lib/auth/client-session"

interface HotelPageWrapperProps {
  children: ReactNode
}

export function HotelPageWrapper({ children }: HotelPageWrapperProps) {
  const router = useRouter()
  const [hotelEmail, setHotelEmail] = useState<string>("hotel@teertham.com")
  const [hotelName, setHotelName] = useState<string>("Hotel")
  const [isLoading, setIsLoading] = useState(true)

  useEffect(() => {
    const session = getClientSession("hotel_session")
    if (!session || !validateSessionData(session) || session.role !== "hotel") {
      router.push("/login")
      return
    }
    setHotelEmail(session.email || "hotel@teertham.com")
    setHotelName(session.name || "Hotel")
    setIsLoading(false)
  }, [router])

  if (isLoading) {
    return (
      <div className="flex h-screen items-center justify-center bg-slate-50 dark:bg-slate-950">
        <div className="relative">
          <div className="animate-spin rounded-full h-12 w-12 border-4 border-slate-200 border-t-slate-600" />
        </div>
      </div>
    )
  }

  return (
    <div className="min-h-screen bg-slate-50/50 dark:bg-slate-950/50">
      <HotelHeader hotelEmail={hotelEmail} hotelName={hotelName} />
      <main className="container mx-auto px-4 md:px-6 lg:px-8 py-6 lg:py-8">{children}</main>
    </div>
  )
}
