/**
 * SEO and site configuration constants
 */

export const SITE_CONFIG = {
  name: "Teertham",
  description: "Teertham provides comprehensive solutions and innovative services for your business needs.",
  url: process.env.NEXT_PUBLIC_SITE_URL || "https://teertham.com",
  ogImage: "/og-image.jpg",
  links: {
    twitter: "https://twitter.com/teertham",
    github: "https://github.com/teertham",
  },
} as const

export const SEO_DEFAULTS = {
  titleTemplate: "%s | Teertham",
  defaultTitle: "Teertham - Your Trusted Partner",
  description: SITE_CONFIG.description,
  openGraph: {
    type: "website",
    locale: "en_US",
    url: SITE_CONFIG.url,
    siteName: SITE_CONFIG.name,
  },
  twitter: {
    card: "summary_large_image",
    site: "@teertham",
    creator: "@teertham",
  },
} as const
