// Admin Profile Data Store
export interface AdminProfile {
  id: string
  firstName: string
  lastName: string
  email: string
  phone: string
  avatar: string
  timezone: string
  language: string
  twoFactorEnabled: boolean
  lastLogin: Date
  createdAt: Date
}

export interface PasswordChangeData {
  currentPassword: string
  newPassword: string
}

const defaultProfile: AdminProfile = {
  id: "admin_001",
  firstName: "Admin",
  lastName: "User",
  email: "admin@teertham.com",
  phone: "+91 9876543210",
  avatar: "",
  timezone: "Asia/Kolkata",
  language: "en",
  twoFactorEnabled: false,
  lastLogin: new Date(),
  createdAt: new Date("2024-01-01"),
}

class AdminProfileStore {
  private profile: AdminProfile = { ...defaultProfile }
  private password = "Admin@123"

  getProfile(): AdminProfile {
    return { ...this.profile }
  }

  updateProfile(data: Partial<Omit<AdminProfile, "id" | "createdAt">>): AdminProfile {
    this.profile = { ...this.profile, ...data }
    return this.profile
  }

  updateEmail(newEmail: string): boolean {
    this.profile.email = newEmail
    return true
  }

  changePassword(currentPassword: string, newPassword: string): { success: boolean; message: string } {
    if (currentPassword !== this.password) {
      return { success: false, message: "Current password is incorrect" }
    }
    this.password = newPassword
    return { success: true, message: "Password changed successfully" }
  }

  verifyPassword(password: string): boolean {
    return this.password === password
  }

  updateLastLogin(): void {
    this.profile.lastLogin = new Date()
  }
}

export const adminProfileStore = new AdminProfileStore()
