import { z } from "zod"

export const blockAgentSchema = z.object({
  reason: z.string().min(10, "Reason must be at least 10 characters").max(500, "Reason must not exceed 500 characters"),
})

export const rejectAgentSchema = z.object({
  reason: z.string().min(10, "Reason must be at least 10 characters").max(500, "Reason must not exceed 500 characters"),
})

export type BlockAgentInput = z.infer<typeof blockAgentSchema>
export type RejectAgentInput = z.infer<typeof rejectAgentSchema>
