import { z } from "zod"

const hotelSchema = z.object({
  id: z.string(),
  hotelName: z.string().min(1, "Hotel name is required"),
  hotelPhoto: z.string().min(1, "Hotel photo is required"),
})

const locationSchema = z.object({
  id: z.string(),
  name: z.string().min(1, "Location name is required"),
  image: z.string().min(1, "Image is required"),
  itineraryDescription: z.string().min(1, "Description is required"),
  otherDetails: z.string().min(1, "Other details are required"),
})

const vehicleSchema = z.object({
  id: z.string(),
  vehicleId: z.string().min(1, "Vehicle ID is required"),
  vehicleName: z.string().min(1, "Vehicle name is required"),
  vehiclePhoto: z.string().min(1, "Vehicle photo is required"),
  perDayPrice: z.number().min(0, "Price must be positive"),
})

const pricingSchema = z.object({
  b2cWeekdayPerHead: z.number().min(0, "Price must be positive"),
  b2cWeekendPerHead: z.number().min(0, "Price must be positive"),
  b2bAgentPricing: z.number().min(0, "Price must be positive"),
})

const dayPlanSchema = z.object({
  dayNumber: z.number().min(1).max(15),
  locations: z.array(locationSchema).min(1, "At least one location is required per day"),
  vehicles: z.array(vehicleSchema).min(1, "At least one vehicle is required per day"),
  hotels: z.array(hotelSchema),
  pricing: pricingSchema,
})

export const spiritualPackageFormSchema = z.object({
  cityName: z.string().min(2, "City name must be at least 2 characters").max(50, "City name is too long"),
  dayPlans: z.array(dayPlanSchema).min(1, "At least one day plan is required"),
})

export type SpiritualPackageFormInput = z.infer<typeof spiritualPackageFormSchema>
